<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener\paddle;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Event\SubscriptionPaymentSucceededPaddle;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionCreatedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;

class SubscriptionPaymentSucceeded
{
    private $plan;
    private $user;
    private $subscription;

    public function __construct(
        PlanRepositoryInterface $plan,
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->plan = $plan;
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionPaymentSucceededPaddle $event)
    {
        $subscription_created = $event->getResponse();

        //Deneme var mı?
        $trial = ($subscription_created['status'] == "trialing") ? true : false;

        //Plan ve Kullanıcı Kontrolü Yap
        if (!is_null($plan = $this->plan->findByPaddle($subscription_created['subscription_plan_id']))
            and
            !is_null($user = $this->user->findByEmail($subscription_created['email']))) {

            //Find subscription
            if (!is_null($subscription = $this->subscription->findByPaddle($subscription_created['subscription_id']))) {
                //Renew Subscription
                $this->subscription->enabled($subscription->id);

                //Abonelik yenilendi bilgisi ver
                event(new SubscriptionRenewedForWebhook($subscription, $subscription_created));
            } else {
                //Create New Subscription
                $subscription = $this->subscription->create([
                    'assign_id' => $user->getId(),
                    'paddle_subscription_id' => $subscription_created['subscription_id'],
                    'plan' => $plan,
                    'enabled' => true
                ]);

                //Yeni abonelik bilgisi ver
                event(new SubscriptionCreatedForWebhook($subscription, $subscription_created));
            }

            //Abonelik Sürelerini doldur.
            $this->subscription->createdSubscription($subscription, $trial);
        }

    }
}
