<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\CreatedSubscription;

class SubscriptionFormHandler
{
    public function handle(SubscriptionFormBuilder $builder, SubscriptionRepositoryInterface $repository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $builder->saveForm();

        $subscription = $builder->getFormEntry();

        if (request()->action == "save_create" or request()->action == "save") {
            $repository->createdSubscription($subscription);

            event(new CreatedSubscription($subscription));
        }
    }
}
