<?php namespace Visiosoft\SubscriptionsModule\User;

use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanFeature;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Rinvex\Subscriptions\Models\PlanSubscriptionUsage;
use Rinvex\Subscriptions\Traits\HasSubscriptions;

class UserModel extends \Anomaly\UsersModule\User\UserModel
{
    use HasSubscriptions;


    public function getFeature($featureSlug, $column)
    {
        return $feature = PlanFeature::query()->where($column, $featureSlug)->first();
    }

    public function getSubscriptionUser($column = null, $value = null)
    {
        $sub = PlanSubscription::query()
            ->where('user_id', $this->id);
        if ($column != null) {
            $sub->where($column, $value);
        }
        return $sub->orderByDesc('id')->first();

    }

    public function reduceFeatureUsage($featureSlug, $uses = 1)
    {
        $feature = $this->getFeature($featureSlug, 'slug');
        if (is_null($feature)) {
            return null;
        }

        $sub = $this->getSubscriptionUser('plan_id', $feature->plan_id);
        if (is_null($sub)) {
            return null;
        }

        if ($sub != null) {
            $usage = PlanSubscriptionUsage::query()->where('subscription_id', $sub->id)->first();

            if (is_null($usage)) {
                return null;
            }
            $usage->used = max($usage->used - $uses, 0);

            $usage->save();

            return $usage;
        }
        return null;
    }


    public function getFeatureUsage($featureSlug)
    {
        $feature = $this->getFeature($featureSlug, 'slug');
        if (is_null($feature)) {
            return null;
        }

        $sub = $this->getSubscriptionUser('plan_id', $feature->plan_id);
        if (is_null($sub)) {
            return null;
        }
        if ($sub != null) {
            $usage = PlanSubscriptionUsage::query()->where('subscription_id', $sub->id)->first();
            if (is_null($usage)) {
                return null;
            }
            return !$usage->expired() ? $usage->used : 0;
        }
        return null;

    }

    public function addPlanUser($params)
    {
        $plan = Plan::query()->find($params['plan']);
        $user = UserModel::find($params['user']);
        $res = $user->newSubscription($params['name'], $plan);

        $featuresByPlan = $plan->features()->get();
        foreach ($featuresByPlan as $features)
        {
            $user->subscription($res->slug)->recordFeatureUsage($features->slug,$features->value);//add feature Usage
        }
        return $res;
    }
}
