<?php namespace Visiosoft\SubscriptionsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Plan\PlanRepository;
use Anomaly\Streams\Platform\Model\Subscriptions\SubscriptionsPlansEntryModel;
use Visiosoft\SubscriptionsModule\Plan\PlanModel;
use Visiosoft\SubscriptionsModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SubscriptionsModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Subscriptions\SubscriptionsUserEntryModel;
use Visiosoft\SubscriptionsModule\User\UserModel;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionRepository;
use Anomaly\Streams\Platform\Model\Subscriptions\SubscriptionsSubscriptionEntryModel;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;
use Illuminate\Routing\Router;

class SubscriptionsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/subscriptions'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\UserController@index',
        'admin/subscriptions/user/passive'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\UserController@showPassive',
        'admin/subscriptions/user/renew/{id}'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\UserController@renew',
        'admin/subscriptions/create'    => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\UserController@create',
        'admin/subscriptions/user/edit/{id}' => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\UserController@edit',
        'admin/subscriptions'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\SubscriptionController@index',
        'admin/subscriptions/create'    => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\SubscriptionController@create',
        'admin/subscriptions/edit/{id}' => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\SubscriptionController@edit',

        'admin/subscriptions/features'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\FeaturesController@index',
        'admin/subscriptions/features/create'           => 'Visiosoft\SubscriptionsModule\Http\Controller\Admin\FeaturesController@create',


        'subscriptions'           => [
            'as' => 'visiosoft.module.subscriptions::subscriptions-page',
            'uses' => 'Visiosoft\SubscriptionsModule\Http\Controller\SubscriptionController@view',
        ],
        'subscriptions/buy/{id}' => [
            'as' => 'visiosoft.module.subscriptions::buy-pack',
            'uses' => 'Visiosoft\SubscriptionsModule\Http\Controller\SubscriptionController@addCart'
        ],

        'subscriptions/buydemo/{id}' => [
            'as' => 'visiosoft.module.subscriptions::buy-demo',
            'uses' => 'Visiosoft\SubscriptionsModule\Http\Controller\SubscriptionController@buyDemo'
        ],
        'subscriptions/cron' => 'Visiosoft\SubscriptionsModule\Http\Controller\SubscriptionController@SubscriptionControl',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SubscriptionsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SubscriptionsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\SubscriptionsModule\Event\ExampleEvent::class => [
        //    Visiosoft\SubscriptionsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SubscriptionsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SubscriptionsUserEntryModel::class => UserModel::class,
        SubscriptionsSubscriptionEntryModel::class => SubscriptionModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserRepositoryInterface::class => UserRepository::class,
        SubscriptionRepositoryInterface::class => SubscriptionRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
        \Rinvex\Subscriptions\Providers\SubscriptionsServiceProvider::class

    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
