<?php namespace Visiosoft\SubscriptionsModule\Http\Controller\Admin;

use Illuminate\Http\Request;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Form\FeaturesFormBuilder;
use Visiosoft\SubscriptionsModule\Subscription\Table\FeaturesTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class FeaturesController extends AdminController
{
    public function index(FeaturesTableBuilder $table)
    {
        return $table->render();
    }

    public function create(FeaturesFormBuilder $form, Request $request, Plan $plans)
    {
        $newplans = [];
        $fields = $form->getFields();
        foreach ($plans::query()->get() as $plan) {
            $newplans[$plan->id] = $plan->slug;
        }

        $fields = array_merge([
            'plan' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.plan.name',
                'type' => 'anomaly.field_type.select',
                'config' => [
                    'options' => $newplans
                ]
            ],
        ],$fields);
        $form->setFields($fields);
        return $form->render();
    }

}
