<?php namespace Visiosoft\SubscriptionsModule\User\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\UserModel;
use Rinvex\Subscriptions\Models\PlanSubscription;

class UserFormBuilder extends FormBuilder
{
    protected $model = PlanSubscription::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'name' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.name.name',
            'type' => 'anomaly.field_type.text',
        ],
        'user' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.user.name',
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
            ]
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save'
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/subscriptions/user',
        'success_message'   => 'visiosoft.module.subscriptions::message.added_user.message',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
