<?php namespace Visiosoft\SubscriptionsModule\Subscription\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanFeature;
use Rinvex\Subscriptions\Models\PlanSubscription;

class FeaturesTableBuilder extends TableBuilder
{
    protected $model = PlanFeature::class;
    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'plan'          => [
            'heading' => 'visiosoft.module.subscriptions::field.plan.subject',
            'wrapper'     => '
                    <span>{value.plan_name}</span>',
            'value'       => [
                'plan_name' => 'entry.plan.name',
            ],
        ],
        'name'          => [
            'heading' => 'visiosoft.module.subscriptions::field.name.name',
            'wrapper'     => '<span>{entry.name}</span>',
        ],
        'value'          => [
            'heading' => 'visiosoft.module.subscriptions::field.value.name',
            'wrapper'     => '<span>{entry.value}</span>',
        ],
        'resettable_period'          => [
            'heading' => 'visiosoft.module.subscriptions::field.resettable_period.name',
            'wrapper'     => '<span>{entry.resettable_period}</span>',
        ],
        'resettable_interval'          => [
            'heading' => 'visiosoft.module.subscriptions::field.resettable_interval.name',
            'wrapper'     => '<span>{entry.resettable_interval}</span>',
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
