<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Illuminate\Http\Request;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanFeature;
use Visiosoft\SubscriptionsModule\Subscription\Form\SubscriptionFormBuilder;

class FeaturesFormHandler
{
    public function handle(FeaturesFormBuilder $builder) {

        if (!$builder->canSave()) {
            return;
        }
        $request = $builder->getPostData();
        $plan = Plan::query()->find($request['plan']);
        $plan->features()->saveMany([
            new PlanFeature(
                [
                    'name' => $request['name'],
                    'value' => $request['value'],
                    'sort_order' => 0,
                    'resettable_period' => $request['resettable_period'],
                    'resettable_interval' => $request['resettable_interval']
                ]
            ),
        ]);

    }
}
