<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSubscriptionsCreateSubscriptionRenewRequestStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'subscriptionRenewRequest',
        'title_column' => 'status',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subscription' => [
            'required' => true,
        ],
        'old_plan' => [
            'required' => true,
        ],
        'new_plan',
        'order' => [
            'required' => true,
        ],
        'status' => [
            'required' => true,
        ],
    ];

}
