<?php namespace Visiosoft\SubscriptionsModule\Subscription;

use DateTime;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SubscriptionRepository extends EntryRepository implements SubscriptionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SubscriptionModel
     */
    protected $model;

    /**
     * Create a new SubscriptionRepository instance.
     *
     * @param SubscriptionModel $model
     */
    public function __construct(SubscriptionModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $subscription_id
     * @return mixed|string|null
     */
    public function getRemaining($subscription_id, $type = "table")
    {
        $subscription = $this->find($subscription_id);
        if (!is_null($subscription)) {
            $expires = $subscription->expires_at;
            $start = now()
//                ->addDay(3)
                ->format('Y-m-d H:i:s');

            $dStart = new DateTime($start);
            $dEnd = new DateTime($expires);
            $dDiff = $dDiff = $dStart
                ->diff($dEnd)
                ->format('%r%a');

            if ($type == "table") {
                return ($dDiff > 0) ? $dDiff . " "
                    . trans('visiosoft.module.subscriptions::field.day.name')
                    : "<font color='red'>" . trans('visiosoft.module.subscriptions::field.expired.name') . "</font>";
            }
            return $dDiff;
        }
        return null;
    }
}
