<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Subscription\Event\SubscriptionCreateWithPaddle;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\createSubscription;

class newSubscriptionWithPaddle
{
    private $plan;
    private $user;
    private $subscription;

    public function __construct(
        PlanRepositoryInterface $plan,
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->plan = $plan;
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionCreateWithPaddle $event)
    {
        $subscriptionPaddleResponse = $event->getSubscriptionResponse();
        $subscriptionPaddle = $event->getSubscription();
        if (!empty($plan_id = $subscriptionPaddleResponse['subscription_plan_id'])) {
            if (!is_null($plan = $this->plan->findByPaddle($plan_id))
                and
                !is_null($user = $this->user->findByEmail($subscriptionPaddle['email']))) {
                $subscription = $this->subscription->create([
                    'assign_id' => $user->getId(),
                    'plan_id' => $plan->id,
                ]);

                event(new createSubscription($subscription));

                return ['status' => true, "relation" => $subscription];
            }
        } else {
            return response()->json(['status' => 'error', 'message' => 'Paddle ile bağlantılı bir plan veya email adresine kayıtlı kullanıcı bulunamadı!']);
        }
    }
}
