<?php namespace Visiosoft\SubscriptionsModule\Plan;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;

class PlanSeeder extends Seeder
{

    private $plan;

    public function __construct(PlanRepositoryInterface $plan)
    {
        $this->plan = $plan;
        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->plan->create([
            'en' => [
                'name' => 'Free'
            ],
            'slug' => str_slug('free'),
            'price' => '0',
            'currency' => 'USD',
            'trial_interval' => 15,
            'trial_period' => 'day',
        ]);
        $this->plan->create([
            'en' => [
                'name' => 'Default'
            ],
            'slug' => str_slug('default'),
            'price' => '10,00',
            'currency' => 'USD',
            'trial_interval' => 15,
            'trial_period' => 'day',
            'interval' => 1,
            'interval_period' => 'month'
        ]);

        $this->plan->create([
            'en' => [
                'name' => 'Pro'
            ],
            'slug' => str_slug('pro'),
            'price' => '100,00',
            'currency' => 'USD',
            'interval' => 1,
            'interval_period' => 'month'
        ]);
    }
}
