<?php namespace Visiosoft\SubscriptionsModule\Subscription\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Rinvex\Subscriptions\Models\Plan;

class SubscriptionTableBuilder extends TableBuilder
{
    protected $model = Plan::class;
    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'name'          => [
            'heading' => 'visiosoft.module.subscriptions::field.name.name',
            'wrapper'     => '<span>{entry.name}</span>',
        ],
        'price'          => [
            'heading' => 'visiosoft.module.subscriptions::field.price.name',
            'wrapper'     => '<span>{entry.price} {entry.currency}</span>',
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
