<?php namespace Visiosoft\SubscriptionsModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\User;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CloudsiteModule\Site\Event\DeleteSite;
use Visiosoft\CloudsiteModule\Site\Event\SuspendSite;
use Visiosoft\CloudsiteModule\Site\SiteModel;
use Visiosoft\NotificationsModule\Notify\NotifyModel;
use Visiosoft\SubscriptionsModule\Subscription\Event\last3days;
use Visiosoft\SubscriptionsModule\Subscription\Event\lastday;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneMonthLater;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneWeekLater;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\SubscriptionsModule\User\UserModel;

class SubscriptionController extends PublicController
{
    public function view()
    {
        $plan = Plan::query()->get();
        return $this->view->make('visiosoft.module.subscriptions::default', compact('plan'));
    }

    public function addCart($id)
    {
        $plan = Plan::query()->find($id);
        $user = new UsersUsersEntryModel();
        $user->name = $plan->name;
        $user->id = $plan->id;
        $user->price = $plan->price;
        $cart = $this->dispatch(new GetCart());
        $cart->add($user, 1);
        return redirect('/cart');

    }

    public function SubscriptionControl(
        Dispatcher $events,
        NotifyModel $notifyModel,
        User $user,
        SubscriptionModel $subscriptionModel,
        SiteModel $siteModel,
        SettingRepositoryInterface $settings)
    {
        //Son 3 gün
        $last3days_subscriptions = $subscriptionModel->findEndingPeriodBySubscriptions(1, 3);
        foreach ($last3days_subscriptions as $last3days_subscription) {
            $params = array();
            $params['user'] = $user->find($last3days_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "+3" and $subdomain != null) {
                $events->dispatch(new last3days($params));
                $notifyModel->addNotifyLog($params['subdomain'], "+3");
            }
        }

        //Son 1 gün
        $lastday_subscriptions = $subscriptionModel->findEndingPeriodBySubscriptions(0, 1);
        foreach ($lastday_subscriptions as $lastday_subscription) {
            $params = array();
            $params['user'] = $user->find($lastday_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "+1" and $subdomain != null) {
                $site = array();
                $site['suspend'] = "true";
                $site['subdomain'] = $params['subdomain'];
                $events->dispatch(new SuspendSite($site, $settings));
                $events->dispatch(new lastday($params));
                $notifyModel->addNotifyLog($params['subdomain'], "+1");
            }
        }

        //1 hafta sonra
        $later_7_days_subscriptions = $subscriptionModel->findEndingLaterPeriodBySubscriptions(0, 7);
        foreach ($later_7_days_subscriptions as $later_7_days_subscription) {
            $params = array();
            $params['user'] = $user->find($later_7_days_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "-7" and $subdomain != null) {
                $events->dispatch(new OneWeekLater($params));
                $notifyModel->addNotifyLog($params['subdomain'], "-7");
            }
        }

        //1 ay sonra
        $later_30_days_subscriptions = $subscriptionModel->findEndingLaterPeriodBySubscriptions(7, 30);
        foreach ($later_30_days_subscriptions as $later_30_days_subscription) {
            $params = array();
            $params['user'] = $user->find($later_30_days_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "-30" and $subdomain != null) {
                $site['subdomain'] = $params['subdomain'];
                $events->dispatch(new DeleteSite($subdomain,$settings));
                $events->dispatch(new OneMonthLater($params));
                $notifyModel->addNotifyLog($params['subdomain'], "-30");
            }
        }
    }
}
