<?php namespace Visiosoft\SubscriptionsModule\User\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Illuminate\Database\Eloquent\Builder;

class UserTableBuilder extends TableBuilder
{

    protected $model = PlanSubscription::class;

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'user'          => [
            'heading' => 'visiosoft.module.subscriptions::field.user.subject',
            'wrapper'     => '<span><a href="/admin/users/edit/{value.user_id}">{value.user_name}</a></span>',
            'value'       => [
                'user_name' => 'entry.user.email',
                'user_id' => 'entry.user.id',
            ],
        ],
        'plan'          => [
            'heading' => 'visiosoft.module.subscriptions::field.plan.subject',
            'wrapper'     => '
                    <span>{value.plan_name}</span>',
            'value'       => [
                'plan_name' => 'entry.plan.name',
            ],
        ],
        'name'          => [
            'heading' => 'visiosoft.module.subscriptions::field.name.name',
            'wrapper'     => '<span>{entry.name}</span>',
        ],
        'start'          => [
            'heading' => 'visiosoft.module.subscriptions::field.start.name',
            'wrapper'     => '<span>{entry.starts_at}</span>',
        ],
        'finish'          => [
            'heading' => 'visiosoft.module.subscriptions::field.finish.name',
            'wrapper'     => '<span>{entry.ends_at}</span>',
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'renew' => [
            'text' => 'Renew',
            'type' => 'success',
            'href' => '/admin/subscriptions/renew/{entry.slug},{entry.user.id}'
        ]
    ];

    public function onQuerying(Builder $query)
    {
        $query->where('canceled_at', null);
    }

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
