<?php namespace Visiosoft\SubscriptionsModule\Subscription;


use Rinvex\Subscriptions\Models\PlanSubscription;
use Illuminate\Support\Facades\Auth;
use Rinvex\Subscriptions\Models\Plan;
use Visiosoft\SubscriptionsModule\User\UserModel;

class SubscriptionModel
{
    public function addPlanUser($id)
    {
        $plan = Plan::query()->find($id);
        $user = UserModel::find(Auth::id());
        $res = $user->newSubscription($user->display_name . " Plan", $plan);

//        $featuresByPlan = $plan->features()->get();
//        foreach ($featuresByPlan as $features) {
//            $user->subscription($res->slug)->recordFeatureUsage($features->slug, $features->value);
//        }
    }

    public function addDemoPlanUser($id)
    {
        $plan = Plan::query()->find($id);
        $user = UserModel::find(Auth::id());
        $res = $user->newSubscription($user->display_name . " Demo", $plan);

        $featuresByPlan = $plan->features()->get();
        foreach ($featuresByPlan as $features) {
            $user->subscription($res->slug)->recordFeatureUsage($features->slug, $features->value);
        }
    }

    public function findEndingPeriodBySubscriptions($between_first = 3, $between_last = 1)
    {
        $from = now()->addDays($between_first);
        $to = now()->addDays($between_last);

        return PlanSubscription::query()
            ->where('ends_at', '>=', now())
            ->WhereNull('canceled_at')
            ->whereBetween('ends_at', [$from, $to])->get();
    }

    public function findEndingLaterPeriodBySubscriptions($between_first = 3, $between_last = 1)
    {
        return PlanSubscription::query()
            ->where('ends_at', '<', now())//süresi bitmeiş olacak
            ->whereRaw('NOW() BETWEEN DATE_ADD(`ends_at`, INTERVAL ' . $between_first . ' DAY) AND DATE_ADD(`ends_at`, INTERVAL ' . $between_last . ' DAY)')
            ->get();
    }
}
