<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Rinvex\Subscriptions\Models\Plan;
use Illuminate\Http\Request;
use Visiosoft\SubscriptionsModule\Subscription\Form\SubscriptionFormBuilder;

class SubscriptionFormHandler
{
    public function handle(SubscriptionFormBuilder $builder)
    {

        if (!$builder->canSave()) {
            return;
        }
        $request = $builder->getPostData();
        if ($builder->getActions()[0]['slug'] == "update") {
            Plan::query()->find($builder->getEntry())->update($request);
        } else {
            $plan = app('rinvex.subscriptions.plan')->create([
                'name' => $request['name'],
                'description' => $request['description'],
                'price' => $request['price'],
                'signup_fee' => $request['signup_fee'],
                'invoice_period' => $request['invoice_period'],
                'invoice_interval' => $request['invoice_interval'],
                'trial_period' => $request['trial_period'],
                'trial_interval' => $request['trial_interval'],
                'sort_order' => 0,
                'currency' => $request['currency'],
            ]);
        }
    }
}
