<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Rinvex\Subscriptions\Models\Plan;

class SubscriptionFormBuilder extends FormBuilder
{

    protected $model = Plan::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $handler = SubscriptionFormHandler::class; // Assumes @handle

    protected $fields = [
        'name' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.name.name',
            'type' => 'anomaly.field_type.text',
        ],
        'description' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.description.name',
            'type' => 'anomaly.field_type.textarea',
        ],
        'price' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.price.name',
            'type' => 'anomaly.field_type.decimal',
            'config' => [
                "point" => ",",
                'min' => 0,
                "separator" => ".",
                "decimals" => 2,
            ]
        ],
        'currency' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.currency.name',
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
            ],
        ],
        'signup_fee' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.signup_fee.name',
            'type' => 'anomaly.field_type.decimal',
            'config' => [
                "point" => ",",
                'min' => 0,
                "separator" => ".",
                "decimals" => 2,
            ]
        ],
        'invoice_period' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.invoice_period.name',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 1,
            ]
        ],
        'invoice_interval' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.invoice_interval.name',
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'month' => 'Month',
                ],
                'default_value' => 'month',
                'separator' => ':',
            ]
        ],
        'trial_period' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.trial_period.name',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 15,
            ]
        ],
        'trial_interval' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.trial_interval.name',
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'day' => 'Day',
                ],
                'default_value' => 'day',
                'separator' => ':',
            ]
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save',
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/subscriptions/',
        'success_message'   => 'visiosoft.module.subscriptions::message.created_plan.message',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
