<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Rinvex\Subscriptions\Models\PlanFeature;

class FeaturesFormBuilder extends FormBuilder
{
    protected $model = PlanFeature::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'name' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.name.name',
            'type' => 'anomaly.field_type.text',
        ],
        'value' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.value.name',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 1,
            ]
        ],
        'resettable_period' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.resettable_period.name',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 1,
            ]
        ],
        'resettable_interval' => [
            'required' => true,
            'label' => 'visiosoft.module.subscriptions::field.resettable_interval.name',
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'month' => 'Month',
                ],
                'default_value' => 'month',
                'separator' => ':',
            ]
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save'
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/subscriptions/features',
        'success_message'   => 'visiosoft.module.subscriptions::message.created_feature.message',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
