
CREATE TABLE `default_plans` (
  `id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` text COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `price` decimal(8,2) NOT NULL DEFAULT 0.00,
  `signup_fee` decimal(8,2) NOT NULL DEFAULT 0.00,
  `currency` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `trial_period` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `trial_interval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'day',
  `invoice_period` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `invoice_interval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'month',
  `grace_period` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `grace_interval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'day',
  `prorate_day` tinyint(3) UNSIGNED DEFAULT NULL,
  `prorate_period` tinyint(3) UNSIGNED DEFAULT NULL,
  `prorate_extend_due` tinyint(3) UNSIGNED DEFAULT NULL,
  `active_subscribers_limit` smallint(5) UNSIGNED DEFAULT NULL,
  `sort_order` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `default_plans` (`id`, `slug`, `name`, `description`, `is_active`, `price`, `signup_fee`, `currency`, `trial_period`, `trial_interval`, `invoice_period`, `invoice_interval`, `grace_period`, `grace_interval`, `prorate_day`, `prorate_period`, `prorate_extend_due`, `active_subscribers_limit`, `sort_order`, `created_at`, `updated_at`, `deleted_at`) VALUES
(24, 'standart', '{\"en\":\"Standart\"}', '{\"en\":\"Standart Package\"}', 1, '50.00', '50.00', 'USD', 0, 'day', 1, 'month', 0, 'day', NULL, NULL, NULL, NULL, 2, '2019-04-11 11:19:47', '2019-04-11 11:19:47', NULL),
(25, 'professional', '{\"en\":\"Professional\"}', '{\"en\":\"Professional Package\"}', 1, '100.00', '100.00', 'USD', 0, 'day', 1, 'month', 0, 'day', NULL, NULL, NULL, NULL, 3, '2019-04-11 11:20:19', '2019-04-11 11:20:19', NULL);


CREATE TABLE `default_plan_features` (
  `id` int(10) UNSIGNED NOT NULL,
  `plan_id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` text COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `resettable_period` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `resettable_interval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'month',
  `sort_order` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `default_plan_features` (`id`, `plan_id`, `slug`, `name`, `description`, `value`, `resettable_period`, `resettable_interval`, `sort_order`, `created_at`, `updated_at`, `deleted_at`) VALUES
(17, 24, 'unlimited-ads', '{\"en\":\"Unlimited Ads\"}', NULL, '10000000', 1, 'month', 3, '2019-04-11 11:25:56', '2019-04-11 11:25:56', NULL),
(18, 24, '20-modules', '{\"en\":\"20 Modules\"}', NULL, '20', 1, 'month', 4, '2019-04-11 11:26:08', '2019-04-11 11:26:08', NULL),
(19, 24, 'e-shop-systems', '{\"en\":\"E-Shop Systems\"}', NULL, '1', 1, 'month', 5, '2019-04-11 11:26:24', '2019-04-11 11:26:24', NULL),
(20, 25, 'unlimited-ads-1', '{\"en\":\"Unlimited Ads\"}', NULL, '100000000', 1, 'month', 6, '2019-04-11 11:26:44', '2019-04-11 11:26:44', NULL),
(21, 25, 'all-modules', '{\"en\":\"All Modules\"}', NULL, '10000', 1, 'month', 7, '2019-04-11 11:26:58', '2019-04-11 11:26:58', NULL),
(22, 25, 'e-shop-systems-1', '{\"en\":\"E-Shop Systems\"}', NULL, '1', 1, 'month', 8, '2019-04-11 11:27:09', '2019-04-11 11:27:09', NULL),
(23, 25, 'mobile-apps', '{\"en\":\"Mobile Apps\"}', NULL, '1', 1, 'month', 9, '2019-04-11 11:27:20', '2019-04-11 11:27:20', NULL);


CREATE TABLE `default_plan_subscriptions` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `plan_id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` text COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `trial_ends_at` datetime DEFAULT NULL,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `cancels_at` datetime DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `timezone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `default_plan_subscription_usage` (
  `id` int(10) UNSIGNED NOT NULL,
  `subscription_id` int(10) UNSIGNED NOT NULL,
  `feature_id` int(10) UNSIGNED NOT NULL,
  `used` smallint(5) UNSIGNED NOT NULL,
  `valid_until` datetime DEFAULT NULL,
  `timezone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


ALTER TABLE `default_plans`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `plans_slug_unique` (`slug`);


ALTER TABLE `default_plan_features`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `plan_features_plan_id_slug_unique` (`plan_id`,`slug`);


ALTER TABLE `default_plan_subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `plan_subscriptions_slug_unique` (`slug`),
  ADD KEY `plan_subscriptions_user_type_user_id_index` (`user_type`,`user_id`),
  ADD KEY `plan_subscriptions_plan_id_foreign` (`plan_id`);


ALTER TABLE `default_plan_subscription_usage`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `plan_subscription_usage_subscription_id_feature_id_unique` (`subscription_id`,`feature_id`),
  ADD KEY `plan_subscription_usage_feature_id_foreign` (`feature_id`);


ALTER TABLE `default_plans`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;


ALTER TABLE `default_plan_features`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;


ALTER TABLE `default_plan_subscriptions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;


ALTER TABLE `default_plan_subscription_usage`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;


ALTER TABLE `default_plan_features`
  ADD CONSTRAINT `plan_features_plan_id_foreign` FOREIGN KEY (`plan_id`) REFERENCES `default_plans` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;


ALTER TABLE `default_plan_subscriptions`
  ADD CONSTRAINT `plan_subscriptions_plan_id_foreign` FOREIGN KEY (`plan_id`) REFERENCES `default_plans` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;


ALTER TABLE `default_plan_subscription_usage`
  ADD CONSTRAINT `plan_subscription_usage_feature_id_foreign` FOREIGN KEY (`feature_id`) REFERENCES `default_plan_features` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `plan_subscription_usage_subscription_id_foreign` FOREIGN KEY (`subscription_id`) REFERENCES `default_plan_subscriptions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;
