<?php namespace Visiosoft\SubscriptionsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Visiosoft\SubscriptionsModule\User\Table\PassiveSubscriptionsTableBuilder;
use Visiosoft\SubscriptionsModule\User\UserModel;
use Illuminate\Http\Request;
use Rinvex\Subscriptions\Models\Plan;
use Visiosoft\SubscriptionsModule\User\Form\UserFormBuilder;
use Visiosoft\SubscriptionsModule\User\Table\UserTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class UserController extends AdminController
{

    public function index(UserTableBuilder $table, Request $request, PlanSubscription $planSubscription)
    {

        $user = UserModel::query()->find(1);
//        $bookingsOfUser = $planSubscription->ofUser($user)->get();
//        dd($bookingsOfUser);


        if ($request->action == "delete") {
            foreach ($this->request->id as $item) {
                $subscription = PlanSubscription::query()->find($item);
                $user = UserModel::find($subscription->user_id);
                $user->subscription($subscription->slug)->cancel(true);
            }
            return back()->withSuccess([trans('visiosoft.module.subscriptions::message.success.subjects')]);
        }
        return $table->render();
    }

    public function showPassive(PassiveSubscriptionsTableBuilder $table)
    {
        return $table->render();
    }

    public function renew($id)
    {
        $subscription = PlanSubscription::find($id);
        $user = UserModel::find($subscription->user_id);
        $user->subscription($subscription->slug)->renew();
        return back()->withSuccess([trans('visiosoft.module.subscriptions::message.success.subjects')]);
    }

    public function create(UserFormBuilder $form, Plan $plans)
    {
        $form->setHandler('Visiosoft\SubscriptionsModule\User\Form\UserFormHandler');
        $newplans = [];
        $fields = $form->getFields();
        foreach ($plans::query()->get() as $plan) {
            $newplans[$plan->id] = $plan->slug;
        }

        $fields = array_merge($fields,
            [
                'plan' => [
                    'required' => true,
                    'label' => 'visiosoft.module.subscriptions::field.plan.name',
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => $newplans
                    ]
                ],
            ]);
        $form->setFields($fields);
        return $form->render();
    }

}
