<?php namespace Visiosoft\SubscriptionsModule\Http\Controller\Admin;

use Rinvex\Subscriptions\Models\Plan;
use Visiosoft\SubscriptionsModule\Subscription\Form\SubscriptionFormBuilder;
use Visiosoft\SubscriptionsModule\Subscription\Table\SubscriptionTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SubscriptionsModule\User\UserModel;

class SubscriptionController extends AdminController
{
    public function index(SubscriptionTableBuilder $table)
    {
        return $table->render();
    }

    public function edit(SubscriptionFormBuilder $form, $id)
    {
        $entry = Plan::query()->find($id);
        $form->setActions(['update']);
        $form->setFields([
            'name' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.name.name',
                'type' => 'anomaly.field_type.text',
                'value' => $entry->name,
            ],
            'description' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.description.name',
                'type' => 'anomaly.field_type.textarea',
                'value' => $entry->description,
            ],
            'price' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.price.name',
                'type' => 'anomaly.field_type.decimal',
                'value' => $entry->price,
                'config' => [
                    "point" => ",",
                    'min' => 0,
                    "separator" => ".",
                    "decimals" => 2,
                ]
            ],
            'currency' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.currency.name',
                'type' => 'anomaly.field_type.select',
                'value' => $entry->currency,
                'config' => [
                    'handler' => 'currencies',
                ],
            ],
            'signup_fee' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.signup_fee.name',
                'type' => 'anomaly.field_type.decimal',
                'value' => $entry->signup_fee,
                'config' => [
                    "point" => ",",
                    'min' => 0,
                    "separator" => ".",
                    "decimals" => 2,
                ]
            ],
            'invoice_period' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.invoice_period.name',
                'type' => 'anomaly.field_type.integer',
                'value' => $entry->invoice_period,

            ],
            'invoice_interval' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.invoice_interval.name',
                'type' => 'anomaly.field_type.select',
                'value' => $entry->invoice_interval,
                'config' => [
                    'options' => [
                        'month' => 'Month',
                    ],
                    'separator' => ':',
                ]
            ],
            'trial_period' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.trial_period.name',
                'type' => 'anomaly.field_type.integer',
                'value' => $entry->trial_period,
            ],
            'trial_interval' => [
                'required' => true,
                'label' => 'visiosoft.module.subscriptions::field.trial_interval.name',
                'type' => 'anomaly.field_type.select',
                'value' => $entry->trial_interval,
                'config' => [
                    'options' => [
                        'day' => 'Day',
                    ],
                    'separator' => ':',
                ]
            ],
        ]);
        return $form->render($id);
    }

    public function create(SubscriptionFormBuilder $form)
    {
        return $form->render();
    }

    public function renew(UserModel $user, $slug,$user_id)
    {
        $user = $user->find($user_id);

        $user->subscription($slug)->renew();

        return back()->withSuccess([trans('visiosoft.module.subscriptions::message.success.subject')]);

    }

}
