<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Visiosoft\OrdersModule\Order\OrderModel;

class VisiosoftModuleSubscriptionsCreateSubscriptionsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'subscription' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => PlanSubscription::class,
            ]
        ],
        'old_plan' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Plan::class,
            ]
        ],
        'new_plan' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Plan::class,
                'default_value' => null,
            ]
        ],
        'order' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => OrderModel::class,

            ]
        ],
        'status' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'waiting' => 'waiting',
                    'success' => 'success',
                    'canceled' => 'canceled',
                ],
                'separator' => ':',
            ],
        ],

    ];


}
