<?php namespace Visiosoft\SubscriptionsModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Rinvex\Subscriptions\Models\Plan;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CloudsiteModule\Domain\DomainModel;
use Visiosoft\CloudsiteModule\Site\Event\AddDomainSite;
use Visiosoft\CloudsiteModule\Site\Event\CreateSite;
use Visiosoft\CloudsiteModule\Site\Event\DeleteSite;
use Visiosoft\CloudsiteModule\Site\Event\SuspendSite;
use Visiosoft\CloudsiteModule\Site\SiteModel;
use Visiosoft\NotificationsModule\Notify\NotifyModel;
use Visiosoft\SubscriptionsModule\Subscription\Event\last3days;
use Visiosoft\SubscriptionsModule\Subscription\Event\lastday;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneMonthLater;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneWeekLater;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\SubscriptionsModule\SubscriptionRenewRequest\SubscriptionRenewRequestModel;
use Visiosoft\SubscriptionsModule\User\UserModel;

class SubscriptionController extends PublicController
{
    public function __construct()
    {
        parent::__construct();
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
    }

    public function view(Plan $plans)
    {
        return $this->view->make('visiosoft.module.subscriptions::default', compact('plans'));
    }

    public function buyTrial(PlanSubscription $planSubscription, Plan $plans, $id)
    {
        $isSubscription = $planSubscription->where('plan_id', $id)->where('user_id', Auth::id())->get();
        if (count($isSubscription) == 0 and $plans->find($id)) {
            $SubscriptionModel = new SubscriptionModel();
            $SubscriptionModel->addPlanUser($id);
            return redirect(route('visiosoft.module.subscriptions::profile-subscriptions'));
        }
        return redirect('/')->with('error', [trans('visiosoft.module.subscriptions::field.message_error_two')]);

    }

    public function addCart($id)
    {
        $plan = Plan::query()->find($id);
        $user = new UsersUsersEntryModel();
        $user->name = $plan->name;
        $user->id = $plan->id;
        $user->price = $plan->price;
        $cart = $this->dispatch(new GetCart());
        $cart->add($user, 1);
        return redirect('/cart');

    }

    public function SubscriptionControl(
        Dispatcher $events,
        NotifyModel $notifyModel,
        User $user,
        SubscriptionModel $subscriptionModel,
        SiteModel $siteModel,
        SettingRepositoryInterface $settings)
    {
        //Son 3 gün
        $last3days_subscriptions = $subscriptionModel->findEndingPeriodBySubscriptions(1, 3);
        foreach ($last3days_subscriptions as $last3days_subscription) {
            $params = array();
            $params['user'] = $user->find($last3days_subscription->user_id);
            $site = $siteModel->where('plan_id', $last3days_subscription->id)->first();
            $params['subdomain'] = $site->subdomain;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "+3" and $subdomain != null) {
                $events->dispatch(new last3days($params));
                $notifyModel->addNotifyLog($params['subdomain'], "+3");
            }
        }

        //Son 1 gün
        $lastday_subscriptions = $subscriptionModel->findEndingPeriodBySubscriptions(0, 1);
        foreach ($lastday_subscriptions as $lastday_subscription) {
            $params = array();
            $params['user'] = $user->find($lastday_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "+1" and $subdomain != null) {
                $site = array();
                $site['suspend'] = "true";
                $site['subdomain'] = $params['subdomain'];
                $events->dispatch(new SuspendSite($site, $settings));
                $events->dispatch(new lastday($params));
                $notifyModel->addNotifyLog($params['subdomain'], "+1");
            }
        }

        //1 hafta sonra
        $later_7_days_subscriptions = $subscriptionModel->findEndingLaterPeriodBySubscriptions(0, 7);
        foreach ($later_7_days_subscriptions as $later_7_days_subscription) {
            $params = array();
            $params['user'] = $user->find($later_7_days_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "-7" and $subdomain != null) {
                $events->dispatch(new OneWeekLater($params));
                $notifyModel->addNotifyLog($params['subdomain'], "-7");
            }
        }

        //1 ay sonra
        $later_30_days_subscriptions = $subscriptionModel->findEndingLaterPeriodBySubscriptions(7, 30);
        foreach ($later_30_days_subscriptions as $later_30_days_subscription) {
            $params = array();
            $params['user'] = $user->find($later_30_days_subscription->user_id);
            $params['subdomain'] = $params['user']->username;
            $notifyLog = $notifyModel->getLog('subdomain', $params['subdomain']);
            $subdomain = $siteModel->getSitesBySubdomain($params['subdomain']);
            if ($notifyLog == null or $notifyLog->remaining_days != "-30" and $subdomain != null) {
                $site['subdomain'] = $params['subdomain'];
                $events->dispatch(new DeleteSite($subdomain, $settings));
                $events->dispatch(new OneMonthLater($params));
                $notifyModel->addNotifyLog($params['subdomain'], "-30");
            }
        }
    }

    public function detail(SiteModel $siteModel, PlanSubscription $planSubscription, $id)
    {
        $Subscription = $planSubscription->find($id);
        $sites = $siteModel->where('plan_id', $id)->get();

        return $this->view->make('visiosoft.module.subscriptions::detail', compact('Subscription', 'sites'));
    }

    public function createSite(SettingRepositoryInterface $setting, SiteModel $siteModel, PlanSubscription $planSubscription, Request $request)
    {
        //ilk olarak subscription var mı yok mu kontrol edilir.(id üzerinde)
        $subscription = $planSubscription->where('user_id', Auth::id())->where('id', $request->subscription_id)->first();

        if ($subscription) {
            $siteModel->createSite($request->subdomain, Auth::id(), Auth::user()->username, $request->subscription_id);
            $response['user'] = Auth::user();
            $response['password'] = Auth::user()->username;
            $response['subdomain'] = $request->subdomain;
            $response['username'] = Auth::user()->username;
            $response['email'] = Auth::user()->email;
            $this->events->dispatch(new CreateSite($response, $setting));
            return redirect(route('visiosoft.module.subscriptions::detail-subscriptions', [$request->subscription_id]));
        }
        return redirect('/')->with('error', [trans('visiosoft.module.subscriptions::field.message_error_two')]);
    }

    public function domains(DomainModel $domainModel, SiteModel $siteModel, $id)
    {
        $detail = $siteModel->find($id);
        if ($detail) {
            $domains = $domainModel->where('subdomains_item_id', $id)->get();
            return $this->view->make('visiosoft.module.subscriptions::domains', compact('detail', 'domains'));
        }
        return redirect('/')->with('error', [trans('visiosoft.module.subscriptions::field.message_error_two')]);
    }

    public function createDomain(SiteModel $siteModel, SettingRepositoryInterface $setting, DomainModel $domainModel, Request $request)
    {
        $domain = explode('.', $request->domain);
        $site = $siteModel->find($request->site_id);

        if ($site and count($domain) >= 2 and $domain[0] != "www") {
            $domainModel->create(['subdomains_item_id' => $request->site_id, 'domain' => $request->domain]);

            $response['domain'] = $request->domain;
            $response['subdomain'] = $site->subdomain;
            $this->events->dispatch(new AddDomainSite($response, $setting));

            return redirect(route('visiosoft.module.subscriptions::list-domains', [$request->site_id]))->with('success', ['Success!']);
        }
        return back()->with('error', [trans('visiosoft.module.subscriptions::field.message_error_one')]);
    }

    public function extendSubscription(SubscriptionRenewRequestModel $subscriptionRenewRequestModel, PlanSubscription $planSubscription, Plan $plan, $id)
    {
        $subscription = $planSubscription->find($id);
        if ($subscription) {
            $subscriptionRenewRequestModel->create([
                'subscription_id' => $id,
                'old_plan' => $subscription->plan_id,
            ]);
            return $this->addCart($subscription->plan_id);
        }
        return redirect('/')->with('error', [trans('visiosoft.module.subscriptions::field.message_error_two')]);
    }

    public function selectPlanSubscription(Plan $plans, PlanSubscription $planSubscription, $id)
    {
        $subscription = $planSubscription->find($id);
        return $this->view->make('visiosoft.module.subscriptions::changePlan', compact('id', 'subscription', 'plans'));
    }

    public function changePlanSubscription(SubscriptionRenewRequestModel $subscriptionRenewRequestModel, PlanSubscription $planSubscription, Request $request)
    {
        $subscription_detail = $planSubscription->find($request->subscription_id);
        if ($subscription_detail) {
            $subscriptionRenewRequestModel->create([
                'subscription_id' => $request->subscription_id,
                'old_plan' => $subscription_detail->plan_id,
                'new_plan' => $request->new_plan,
            ]);
            return $this->addCart($request->new_plan);
        }
        return redirect('/')->with('error', [trans('visiosoft.module.subscriptions::field.message_error_two')]);
    }

    public function ListMySubscriptions()
    {
        $isActive = new AdvModel();
        $isActiveSubscriptions = $isActive->is_enabled('subscriptions');
        if ($isActiveSubscriptions) {

            $plans = PlanSubscription::query()
                ->where('user_id', Auth::id())
                ->leftJoin('plans as p1', 'plan_subscriptions.user_id', '=', 'p1.id')
                ->select('p1.name as pname', 'plan_subscriptions.*')
                ->orderByDesc('plan_subscriptions.id')
                ->get();
        }
        return $this->view->make('visiosoft.module.subscriptions::subscriptions', compact('plans'));
    }
}
