<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener\site;

use Visiosoft\SiteModule\Site\Event\CreateSiteOnManuel;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\CreateSubscriptionOnManuel;

class CreateOnManuelForSite
{
    private $subscription;

    public function __construct(SubscriptionRepositoryInterface $subscription)
    {
        $this->subscription = $subscription;
    }

    public function handle(CreateSiteOnManuel $event)
    {

        $subscription = $this->subscription->create([
            'assign' => $event->getAssign(),
            'plan_id' => setting_value('visiosoft.module.subscriptions::register_default_plan'),
            'enabled' => true
        ]);

        $this->subscription->createdSubscription($subscription, true);


        event(new CreateSubscriptionOnManuel($subscription));

        return $subscription;
    }
}
