<?php namespace Visiosoft\SubscriptionsModule\Plan;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;

class PlanSeeder extends Seeder
{

    private $plan;

    public function __construct(PlanRepositoryInterface $plan)
    {
        $this->plan = $plan;
        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->plan->create([
            'en' => [
                'name' => 'Basic Plan'
            ],
            'slug' => str_slug(strtolower('Basic Plan')),
            'price' => '0',
            'currency' => 'USD',
            'trial_interval' => 15,
            'trial_period' => 'day',
            'interval' => 1,
            'interval_period' => 'month',
            'paddle_plan_id' => 618797
        ]);

        $this->plan->create([
            'en' => [
                'name' => 'Business Plan'
            ],
            'slug' => str_slug(strtolower('Business Plan')),
            'price' => '0',
            'currency' => 'USD',
            'trial_interval' => 0,
            'interval' => 1,
            'interval_period' => 'month',
            'paddle_plan_id' => 618799
        ]);
    }
}
