<?php namespace Visiosoft\SubscriptionsModule\Subscription\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class SubscriptionExpired extends Notification implements ShouldQueue
{

    use Queueable;

    public $subscription;
    public $remaining;

    public function __construct($remaining, $subscription)
    {
        $this->subscription = $subscription;
        $this->remaining = $remaining;
    }

    public function via()
    {
        return ['mail'];
    }

    public function toMail()
    {
        return (new MailMessage())
            ->view('visiosoft.theme.base::notifications.email')
            ->subject(trans('visiosoft.module.subscriptions::message.expired_notification.subject',
                ['plan' => ucfirst($this->subscription->plan->name)]))
            ->line(trans('visiosoft.module.subscriptions::message.expired_notification.line1',
                ['plan' => ucfirst($this->subscription->plan->name)]))
            ->salutation(trans('visiosoft.module.subscriptions::message.notification.salutation'));
    }
}
