<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserWasCreated;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class CreatedUser
{
    private $plan;
    private $user;
    private $subscription;

    public function __construct(
        PlanRepositoryInterface $plan,
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->plan = $plan;
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(UserWasCreated $event)
    {
        $user = $this->user->find($event->getUser()->getId());
        $user->subdomain = $user->username;
        $user->save();


        if (is_null($subscription = $this->subscription->findByAssign($user->getId()))) {
            //New Subscription
            $subscription = $this->subscription->create([
                'assign_id' => $user->getId(),
                'plan_id' => setting_value('visiosoft.module.subscriptions::register_default_plan'),
                'enabled' => true
            ]);
            event(new SubscriptionCreated($subscription));

            $this->subscription->enabled($subscription->id, false);

        } else {
            //Renew Subscription
            $this->subscription->enabled($subscription->id);
        }

        $this->subscription->createdSubscription($subscription, true);
    }
}
