<?php namespace Visiosoft\SubscriptionsModule\Plan;

use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PlanRepository extends EntryRepository implements PlanRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PlanModel
     */
    protected $model;

    /**
     * Create a new PlanRepository instance.
     *
     * @param PlanModel $model
     */
    public function __construct(PlanModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function findByPaddle($id)
    {
        if (!is_null($plan = $this->model->where('paddle_plan_id', $id))) {
            return $plan->first();
        }
        return null;
    }
}
