<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\ProfileModule\Events\UserActivatedByMail;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\ExpiredSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreatedForActivatedUser;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionPaymentModuleFailed;

class SubscriptionPaymentFailedMailListener
{
    private $user;
    private $subscription;

    public function __construct(
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionPaymentModuleFailed $event)
    {
        $subscription = $event->getSubscription();

        if (!is_null($subscription->plan)) {
            event(new ExpiredSubscription($subscription));
        }
    }
}
