# Subscription Module

Creates a subscription system for your website.

## Installation

To install this module, simply type the following command in your terminal:
```
composer require visiosoft/module-subscriptions
php artisan addon:install visiosoft.module.subscriptions --seed
```

## Usage

### Subscription Plans

Subscription plans are the main part of the subscription module. You can create as many plans as you want. Each plan has a name, price, duration, and features. You can also set a plan as free.

### Subscription Payments

Subscription payments are the payments that users make to purchase a subscription plan. You can see all the payments in the admin panel. You can also see the payment details and the user who made the payment.

#### Payment Gateways

Works with 'visiosoft/payment-module' and 'visiosoft/currency-module' modules. You can use any payment gateway that is compatible with these modules.

#### Payment Methods

There is a cron job that checks the payment methods and updates the subscription status of the users. You can also run this command manually.

There is a function named periodicPay in the subscription controller file. You can use for automatic payment methods. This function can be called by the cron job.

We suggest you set the cron job to run twice every day and call the periodicPay function in the cron job.(Actually this is how we use it.)

#### Extend Subscription With Payment

If a user has an active subscription and makes a payment, the subscription will be extended. If the payment fails, the subscription will not be extended
and the user will be notified.