<?php namespace Visiosoft\SubscriptionsModule\Subscription;

use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SubscriptionRepository extends EntryRepository implements SubscriptionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SubscriptionModel
     */
    protected $model;

    /**
     * Create a new SubscriptionRepository instance.
     *
     * @param SubscriptionModel $model
     */
    public function __construct(SubscriptionModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $subscription_id
     * @return mixed|string|null
     */
    public function getRemaining($subscription_id)
    {
        $subscription = $this->find($subscription_id);
        if (!is_null($subscription)) {
            $expires = $subscription->expires_at;
            $start = date('Y-m-d H:i:s');
            return ($expires->diff($start)->days < 1)
                ? 'today'
                : $expires->diffInDays($start) . " "
                . trans('visiosoft.module.subscriptions::field.' . $subscription->plan->interval_period . '.name');
        }
        return null;
    }
}
