<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Anomaly\UsersModule\User\Event\UserWasLoggedIn;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\createSubscription;

class RegisterSubscription
{
    /**
     * @var UserRepositoryInterface
     */
    protected $users;

    /**
     * @var SubscriptionRepositoryInterface
     */
    protected $subscription;

    /**
     * @var PlanRepositoryInterface
     */
    protected $plan;


    /**
     * RegisterSubscription constructor.
     * @param UserRepositoryInterface $users
     * @param SubscriptionRepositoryInterface $subscription
     */
    public function __construct(
        UserRepositoryInterface $users,
        SubscriptionRepositoryInterface $subscription,
        PlanRepositoryInterface $plan
    )
    {
        $this->users = $users;
        $this->subscription = $subscription;
        $this->plan = $plan;
    }

    public function handle(UserHasRegistered $event)
    {
        $user = $event->getUser();
        $plan = setting_value('visiosoft.module.subscriptions::default_plan');

        if (is_null($plan)) {
            $plan = $this->plan->first();
        }

        $subscription = $this->subscription->create([
            'assign' => $user,
            'plan' => $plan,
            'enabled' => true,
        ]);

        event(new createSubscription($subscription));
    }
}
