<?php namespace Visiosoft\SubscriptionsModule\Plan\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class PlanTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'name',
        'interval' => [
            'value' => '{entry.interval} {{trans("visiosoft.module.subscriptions::field."~entry.interval_period~".name")}}'
        ],
        'price' => [
            'value' => '{entry.price} {entry.currency}'
        ]
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
