<?php namespace Visiosoft\SubscriptionsModule\Plan;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;

class PlanSeeder extends Seeder
{

    private $plan;

    public function __construct(PlanRepositoryInterface $plan)
    {
        $this->plan = $plan;
        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->plan->create([
            'en' => [
                'name' => 'Free'
            ],
            'slug' => str_slug('Free'),
            'price' => 0,
            'currency' => 'USD',
            'interval' => 15,
            'interval_period' => 'day'
        ]);
    }
}
