function loadScript(src,callback){
    var script = document.createElement("script");
    script.type = "text/javascript";
    if(callback)script.onload=callback;
    document.getElementsByTagName("head")[0].appendChild(script);
    script.src = src;
}

function initialize() {

    var mapVal = $("#map").data();
    var coord = mapVal['mapVal'].split(',').map(Number);
    var point = {lat: coord[0], lng: coord[1]};

    var map = new google.maps.Map(
        document.getElementById('map'), {zoom: 11, center: point});
    var marker = new google.maps.Marker({position: point, map: map});

    var panorama = new google.maps.StreetViewPanorama(
        document.getElementById('pano'), {
            position: point,
            pov: {
                heading: 34,
                pitch: 10
            }
        });
    map.setStreetView(panorama);
}