<?php namespace Visiosoft\StoriesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\StoriesModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\StoriesModule\Story\StoryModel;

class StoriesController extends PublicController
{
	private $itemRepo;

	public function __construct(ItemRepositoryInterface $itemRepo)
	{
		$this->itemRepo = $itemRepo;
	}

	public function index()
    {
        $stories = StoryModel::all();
        $array = [];
        foreach ($stories as $story) {
            if ($story->content) {
                $items = $this->itemRepo->findByStoryId($story->id);
                $items_array = [];
                foreach ($items as $item) {
                    if ($item->content) {
                        array_push($items_array, [
                            'id' => $story->id,
                            'type' => $item->content->folder->slug == 'stories_images' ? 'photo' : 'video',
                            'length' => 5,
                            'src' => $item->content->make()->url(),
                            'preview' => '',
                            'link' => $item->link,
                            'linkText' => $item->linkText,
                            'time' => $item->updated_at->timestamp,
                            'seen' => $item->seen,
                        ]);
                    }
                }

                if ($items_array) {
                    array_push($array, [
                        'id' => $story->id,
                        'photo' => $story->content->make()->url(),
                        'name' => $story->name,
                        'link' => $story->link,
                        'lastUpdated' => $story->updated_at->timestamp,
                        'items' => $items_array
                    ]);
                }
            }
        }
        return response()->json($array);
    }
}
