<?php namespace Visiosoft\StoriesModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;

class StoriesModuleSeeder extends Seeder
{

    /**
     * The disk repository.
     *
     * @var DiskRepositoryInterface
     */
    protected $disks;

    /**
     * The folder repository.
     *
     * @var FolderRepositoryInterface
     */
    protected $folders;

    /**
     * Create a new FolderSeeder instance.
     *
     * @param DiskRepositoryInterface $disks
     * @param FolderRepositoryInterface $folders
     */
    public function __construct(DiskRepositoryInterface $disks, FolderRepositoryInterface $folders)
    {
        parent::__construct();

        $this->disks = $disks;
        $this->folders = $folders;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        //Create Stories Videos Folder
        if (!$this->folders->findBySlug('stories_videos')) {
            $disk = $this->disks->findBySlug('local');

            $this->folders->create([
                'en' => [
                    'name' => 'Stories Videos',
                    'description' => 'A folder for Stories Videos.',
                ],
                'slug' => 'stories_videos',
                'disk' => $disk,
                'allowed_types' => [
                    'mp4'
                ],
            ]);
        };

        // Create Stories Images Folder
	    if (!$this->folders->findBySlug('stories_images')) {
		    $disk = $this->disks->findBySlug('local');

		    $this->folders->create([
			    'en' => [
				    'name' => 'Stories Images',
				    'description' => 'A folder for Stories Images.',
			    ],
			    'slug' => 'stories_images',
			    'disk' => $disk,
			    'allowed_types' => [
				    'jpg', 'jpeg', 'png'
			    ],
		    ]);
	    };
    }
}