<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\StoriesModule\Story\StoryModel;
class VisiosoftModuleStoriesCreateItemsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    protected $fields = [
        "story" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => StoryModel::class,
            ]
        ]
    ];

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'items',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'story',
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'content',
        'link',
        'linkText' => [
            'translatable' => true,
        ],
        'seen',
    ];

}
