<?php namespace Visiosoft\StoriesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\StoriesModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\StoriesModule\Item\ItemRepository;
use Anomaly\Streams\Platform\Model\Stories\StoriesItemsEntryModel;
use Visiosoft\StoriesModule\Item\ItemModel;
use Visiosoft\StoriesModule\Story\Contract\StoryRepositoryInterface;
use Visiosoft\StoriesModule\Story\StoryRepository;
use Anomaly\Streams\Platform\Model\Stories\StoriesStoriesEntryModel;
use Visiosoft\StoriesModule\Story\StoryModel;
use Illuminate\Routing\Router;

class StoriesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/stories/items'           => 'Visiosoft\StoriesModule\Http\Controller\Admin\ItemsController@index',
        'admin/stories/items/create'    => 'Visiosoft\StoriesModule\Http\Controller\Admin\ItemsController@create',
        'admin/stories/items/edit/{id}' => 'Visiosoft\StoriesModule\Http\Controller\Admin\ItemsController@edit',
        'admin/stories'           => 'Visiosoft\StoriesModule\Http\Controller\Admin\StoriesController@index',
        'admin/stories/create'    => 'Visiosoft\StoriesModule\Http\Controller\Admin\StoriesController@create',
        'admin/stories/edit/{id}' => 'Visiosoft\StoriesModule\Http\Controller\Admin\StoriesController@edit',

        'stories'                 => [
        	'as' => 'url.stories',
	        'uses' => 'Visiosoft\StoriesModule\Http\Controller\StoriesController@index',
        ],

    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\StoriesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\StoriesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\StoriesModule\Event\ExampleEvent::class => [
        //    Visiosoft\StoriesModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\StoriesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        StoriesItemsEntryModel::class => ItemModel::class,
        StoriesStoriesEntryModel::class => StoryModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ItemRepositoryInterface::class => ItemRepository::class,
        StoryRepositoryInterface::class => StoryRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
