<?php namespace Visiosoft\StoriesModule\Http\Controller\Admin;

use Visiosoft\StoriesModule\Story\Form\StoryFormBuilder;
use Visiosoft\StoriesModule\Story\Table\StoryTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class StoriesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param StoryTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(StoryTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param StoryFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(StoryFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param StoryFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(StoryFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
