<?php namespace Visiosoft\StoreModule\Store\StoreRegister;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\StoreModule\Store\StoreRegister\Command\AssociateActivationRoles;
use Visiosoft\StoreModule\Store\StoreRegister\Command\SetOptions;
use Anomaly\UsersModule\User\UserModel;

/**
 * Class RegisterFormBuilder
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 */
class StoreRegisterFormBuilder extends FormBuilder
{
    protected $roles = [
        'user',
    ];

    protected $model = UserModel::class;

    protected $actions = [
        'blue' => [
            'text' => 'anomaly.module.users::button.register',
        ],
    ];

    protected $options = [
        'redirect' => '/',
        'success_message' => 'anomaly.module.users::success.user_registered',
        'pending_message' => 'anomaly.module.users::message.pending_admin_activation',
        'confirm_message' => 'anomaly.module.users::message.pending_email_activation',
        'activated_message' => 'anomaly.module.users::message.account_activated',
    ];

    public function onSaved()
    {
        $this->dispatch(new AssociateActivationRoles($this));
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }
}
