<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\Table\StoreTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class StoreController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param StoreTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(StoreTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param StoreFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(StoreFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param StoreFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(StoreFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
