<?php namespace Visiosoft\StoreModule\Listeners;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Ui\Table\Component\Header\Header;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Illuminate\Contracts\Container\Container;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class AddStoreColumn
{
	private $container;

	public function __construct(Container $container)
	{
		$this->container = $container;
	}

	public function handle(TableIsQuerying $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == OrderTableBuilder::class) {
            $this->addStoreColumn($builder);
        }
    }

    protected function addStoreColumn(OrderTableBuilder $builder)
    {
    	if (setting_value('visiosoft.module.store::store_selection_cart')){
		    $header = $this->container->make(Header::class)->setHeading('Store');
		    $builder->getTable()->addHeader($header);

		    $builder->addColumn( [
			    'value' => function (EntryModel $entry) {
				    $options = json_decode($entry->order_option, true);
				    if (array_key_exists('select_stores', $options)) {
					    return app(StoreRepositoryInterface::class)->find($options['select_stores'])->name;
				    }
			    },
		    ]);
	    }
    }
}