<?php namespace Visiosoft\StoreModule\Store;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;

class StoreCriteria extends EntryCriteria
{
    private $storeRepository;
    private $storeUserRepository;

    public function __construct(
        Builder $query,
        StreamInterface $stream,
        $method,
        StoreRepositoryInterface $storeRepository,
        UserRepositoryInterface $storeUserRepository
    )
    {
        parent::__construct($query, $stream, $method);

        $this->storeRepository = $storeRepository;
        $this->storeUserRepository = $storeUserRepository;
    }

    public function getStore()
    {
        return $this->storeRepository->findBy('user_id', Auth::id());
    }

    public function storeAds($userId)
    {
        $advModel = new AdvModel();
        $latest_advs = AdvModel::query()
            ->whereDate('finish_at', '>=', date("Y-m-d H:i:s"))
            ->where('status', '=', 'approved')
            ->where('slug', '!=', '')
            ->where('advs_advs.created_by_id', $userId)
            ->limit(3)
            ->get();

        $ads = $advModel->getLocationNames($latest_advs);
        foreach ($ads as $index => $ad) {
            $ads[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
            $ads[$index] = $advModel->AddAdsDefaultCoverImage($ad);
        }
        return $ads;
    }

    public function hasStore($userId) {
        $store = $this->storeRepository->findBy('user_id', $userId);
        if (is_null($store)) {
            $store = $this->storeUserRepository->findBy('user_id', $userId);
            if ($store) {
                $store = $this->storeRepository->find($store->store_id);
            }
        }

        return $store;
    }

    public function getStoreUsers($store) {
        return $store->getStoreUsers();
    }

    public function getApprovedStores() {
        return $this->storeRepository->getApprovedStores();
    }

    public function getGoldStores() {
        return $this->storeRepository->getGoldStores();
    }

    public function getNonGoldStores() {
        return $this->storeRepository->getNonGoldStores();
    }
}
