const lat = $('#lat').val()
const lng = $('#lng').val()

function initMap() {
    const options = {
        zoom: 15,
    };
    if (lat && lng) {
        options.center = {
            lat: Number(lat),
            lng: Number(lng)
        }
    }
    const geocoder = new google.maps.Geocoder();
    const map = new google.maps.Map(document.getElementById("map"), options);
    const marker = new google.maps.Marker({ map })
    if (lat && lng) {
        marker.setPosition(options.center)
    } else {
        geocodeAddress(geocoder, map, marker, getLocationName())
    }

    google.maps.event.addListener(map, 'click', function (event) {
        placeMarker(event.latLng, map, marker);
    });

    $('select[name=country], select[name=city], select[name=district]').change(function () {
        const type = $(this).closest('.location-wrapper').data('type')
        const name = $(this).attr('name')

        if (name === 'country') {
            delete locationNames.city
        }
        delete locationNames.district

        findLocation($(this).val(), type)
            .then((location) => {
                if (location.success) {
                    locationNames[name] = location.data.name
                    geocodeAddress(geocoder, map, marker, getLocationName())
                }
            })
    })
}

function geocodeAddress(geocoder, resultsMap, marker, address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            resultsMap.setCenter(results[0].geometry.location);
            resultsMap.fitBounds(results[0].geometry.viewport)
            marker.setPosition(results[0].geometry.location)

            $('#lat').val(results[0].geometry.location.lat())
            $('#lng').val(results[0].geometry.location.lng())
        }
    });
}

function placeMarker(location, map, marker) {
    marker.setPosition(location)

    $('#lat').val(location.lat())
    $('#lng').val(location.lng())
}

const getLocationName = () => {
    let name = locationNames.country
    name += locationNames.city ? ' ' + locationNames.city : ''
    name += locationNames.district ? ' ' + locationNames.district : ''
    return name
}

const findLocation = (id, type) => {
    return crudAjax(
        { id, type },
        findLocationUrl,
        'GET',
        () => {},
        true
    )
}
