<?php namespace Visiosoft\StoreModule\Store\Validation;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Str;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class ValidateRegister
{
    public function handle(
        FormBuilder $builder,
        Str $str,
        StoreRepositoryInterface $storeRepository,
        UserRepositoryInterface $userRepository
    )
    {
        // Validate Phone Number
        if (!is_numeric($builder->getPostValue('store_phone'))) {
            $builder->addFormError('store_phone', trans('visiosoft.module.profile::message.error_valid_phone'));
            return false;
        } elseif (!is_null($userRepository->newQuery()->where('gsm_phone', $builder->getPostValue('store_phone'))->first())) {
            $builder->addFormError('store_phone', trans('visiosoft.module.profile::message.registered_phone'));
            return false;
        }

        // Validate Store Slug
        $storeExist = $storeRepository
            ->findBy('slug', $str->slug($builder->getPostValue('store_first_name') . " " . $builder->getPostValue('store_last_name'), '_'));
        if ($storeExist) {
            $builder->addFormError('store_first_name', trans('visiosoft.module.store::message.registered_store'));
            return false;
        }

        return true;
    }
}
