getCountries();

const countryInit = () => {
    new Promise(function (resolve, reject) {
        if (typeof country !== 'undefined') {
            $('select[name="country"]').val(country);
            getCities(parseInt(country));
            if (typeof city !== 'undefined') {
                $('select[name="city"]').val(city);
            }
            resolve(true);
        } else {
            if (parseInt(default_country)) {
                $('select[name="country"]').val(default_country);
                getCities(parseInt(default_country));
                resolve(true);
            }
        }
    });
}

function getCities(country) {
    const selectCityInput = $('select[name=city]')
    selectCityInput.prop('disabled', true)
    crud('id=' + country, '/ajax/getCities', 'POST', function (callback) {
        cities = callback;
        $('select[name="city"]').html("<option>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        selectCityInput.prop('disabled', false)
    })
}
$(document).on('change', 'select[name="country"]', function () {
    getCities($(this).val());
});
function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        async: true,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

function getCountries() {
    crud('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>" + pick_option + "</option>");
        $.each(callback, function (index, value) {
            $('select[name="country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        countryInit();
    })
}