<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreCreatePricesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'prices',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * This field will be added.
     */
    protected $fields = [
        "price" => 'anomaly.field_type.decimal'
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'category' => [
            'required' => true,
            'unique' => true
        ],
        'price' => [
            'required' => true
        ]
    ];
}
