<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Maatwebsite\Excel\ExcelServiceProvider;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\StoreModule\Store\StoreRegister\StoreRegisterFormBuilder;
use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;
use Visiosoft\StoreModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Store\StoreUserEntryModel;
use Visiosoft\StoreModule\User\UserModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\StoreRepository;
use Anomaly\Streams\Platform\Model\Store\StoreStoreEntryModel;
use Visiosoft\StoreModule\Store\StoreModel;
use Illuminate\Routing\Router;

class StoreModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        StoreModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/store/user' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@index',
        'admin/store/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@export',
        'admin/store/user/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@export',
        'admin/store/user/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@create',
        'admin/store/user/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@edit',
        'admin/store' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@index',
        'admin/store/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@create',
        'admin/store/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@edit',
        'store/list' => [
            'as' => 'store::list',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@listStores'
        ],
        's/{slug}/edit/{id}' => [
            'as' => 'store::edit',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@edit',
        ],
        's/{slug}/save/{id}' => [
            'as' => 'store::edit_save',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@store',
        ],
        'store/create' => [
            'as' => 'store::create',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@create',
        ],
        'store/{slug}' => [
            'as' => 'store::view',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@index',
        ],
        'store/{slug}/detail' => [
            'as' => 'store::detail',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@storeDetail',
        ],
        's/{slug}/add-user' => [
            'as' => 'store::add-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@addUser',
        ],
        's/{slug}/remove-user/{id}' => [
            'as' => 'store::remove-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@removeUser',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\StoreModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\StoreModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\StoreModule\Event\ExampleEvent::class => [
        //    Visiosoft\StoreModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        'Excel' => Excel::class,
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        StoreUserEntryModel::class => UserModel::class,
        StoreStoreEntryModel::class => StoreModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserRepositoryInterface::class => UserRepository::class,
        StoreRepositoryInterface::class => StoreRepository::class,
        'store-register' => StoreRegisterFormBuilder::class
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        ExcelServiceProvider::class,
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
